VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CSubclass"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
#If Win32 Then
    Private Declare Function SetWindowLongPtr Lib "user32" Alias "SetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
    Private Declare Function SetClassLongPtr Lib "user32" Alias "SetClassLongA" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
    Private Const GWLP_HINSTANCE = (-6)
    Private Const GWLP_WNDPROC = (-4)
    Private Const GWLP_USERDATA = (-21)
    Private Const GWLP_HWNDPARENT = (-8)
    Private Const GCLP_MENUNAME = (-8)
    Private Const GCLP_HBRBACKGROUND = (-10)
    Private Const GCLP_HCURSOR = (-12)
    Private Const GCLP_HICONSM = (-34)
    Private Const GCLP_HMODULE = (-16)
    Private Const GCLP_WNDPROC = (-24)
    Private Const DWLP_MSGRESULT = 0
    Private Const DWLP_DLGPROC = 4
    Private Const DWLP_USER = 8
#ElseIf Not Win16 And Not Win32 Then
    Private Declare Function SetWindowLongPtr Lib "user32" Alias "SetWindowLongPtrA" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
    Private Declare Function SetClassLongPtr Lib "user32" Alias "SetClassLongAPtr" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
    Private Const GWLP_HINSTANCE = (-6)
    Private Const GWLP_WNDPROC = (-4)
    Private Const GWLP_USERDATA = (-21)
    Private Const GWLP_HWNDPARENT = (-8)
    Private Const GWLP_ID = (-12)
    Private Const GCLP_MENUNAME = (-8)
    Private Const GCLP_HBRBACKGROUND = (-10)
    Private Const GCLP_HCURSOR = (-12)
    Private Const GCLP_HICONSM = (-34)
    Private Const GCLP_HMODULE = (-16)
    Private Const GCLP_WNDPROC = (-24)
    Private Const DWLP_MSGRESULT = 0
    Private Const DWLP_DLGPROC = 8
    Private Const DWLP_USER = 16
#End If

#If DEBUGWINDOWPROC Then
Private m_SCHook As WindowProcHook
#End If

Private m_lOrigWndProc As Long
Private m_hwnd As Long

Public Property Get OrigWndProc() As Long
    OrigWndProc = m_lOrigWndProc
End Property

Public Property Let hwnd(Handle As Long)
    m_hwnd = Handle
End Property

Private Sub Class_Initialize()
    m_lOrigWndProc = 0
    m_hwnd = 0
End Sub

Public Function EnableSubclass() As Boolean
    If m_lOrigWndProc <> 0 Then
        'Already subclassed
        '  Do not allow to subclass a 2nd time
        MsgBox "Error: Already subclassed"
    Else
        #If DEBUGWINDOWPROC Then
            On Error Resume Next
            Set m_SCHook = CreateWindowProcHook
            If Err Then
                MsgBox Err.Description
                Err.Clear
                DisableSubclass
                Exit Function
            End If
            On Error GoTo 0
            With m_SCHook
                .SetMainProc AddressOf Module1.NewWndProc
                m_lOrigWndProc = SetWindowLongPtr(m_hwnd, GWLP_WNDPROC, .ProcAddress)
                .SetDebugProc m_lOrigWndProc
            End With
        #Else
            m_lOrigWndProc = SetWindowLongPtr(m_hwnd, GWLP_WNDPROC, AddressOf Module1.NewWndProc)
        #End If
    End If
    
    If m_lOrigWndProc <> 0 Then
        EnableSubclass = True
    Else
        EnableSubclass = False
    End If
End Function

Public Function DisableSubclass() As Boolean
    If m_lOrigWndProc = 0 Then
        'Do not remove subclass - none exist
        DisableSubclass = False
    Else
        SetWindowLongPtr m_hwnd, GWLP_WNDPROC, m_lOrigWndProc
        m_lOrigWndProc = 0
        DisableSubclass = True
    End If
End Function

Private Sub Class_Terminate()
    Call DisableSubclass
End Sub
